


// Referenced classes of package duggelz.jape:
//            Field

class IntField
    implements Field
{

    public IntField(int offset)
    {
        this.offset = offset;
    }

    public String get(byte data[])
    {
        return Integer.toString(getInt(data));
    }

    public int getInt(byte data[])
    {
        int value = data[offset] & 0xff | (data[offset + 1] & 0xff) << 8 | (data[offset + 2] & 0xff) << 16 | (data[offset + 3] & 0xff) << 24;
        return value;
    }

    public void set(byte data[], String str)
        throws NumberFormatException
    {
        int value = Integer.parseInt(str);
        setInt(data, value);
    }

    public void setInt(byte data[], int value)
    {
        data[offset] = (byte)(value & 0xff);
        data[offset + 1] = (byte)(value >>> 8 & 0xff);
        data[offset + 2] = (byte)(value >>> 16 & 0xff);
        data[offset + 3] = (byte)(value >>> 24 & 0xff);
    }

    private int offset;
}